# 画面設計書 16-OPFS SAHPool テスト

## 概要

本ドキュメントは、SQLite WASMプロジェクトにおけるOPFS SAHPool テスト画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、OPFS SAHPool（Sync Access Handle Pool）VFSの「pause/unpause」機能をテストするためのデモページである。

**業務上の目的・背景**：OPFS SAHPool VFSは、複数のページやWorkerが同一のOPFSストレージにアクセスする際の協調機構を提供する。本画面は、VFSの「pause（一時停止）」と「unpause（再開）」機能をデモンストレーションし、あるハンドラがDBを一時停止している間に別のハンドラがアクセスを引き継ぐシナリオを検証する。これにより、マルチページ・マルチWorker環境でのOPFSリソース共有パターンを確認できる。

**画面へのアクセス方法**：インデックスページ（index.html）の「SAHPool」リンクからアクセスするか、直接 `tests/opfs/sahpool/index.html` にアクセスする。

**主要な操作・処理内容**：
1. ページ読み込み時に2つのWorker（W1, W2）を起動
2. 両Workerが初期化完了を報告したら、テストシーケンス（Pyramid of Doom）を開始
3. W1がVFSを取得 → DB初期化 → クエリ実行 → VFS pause
4. W1がpause中にW2がVFSを取得 → クエリ実行 → VFS削除
5. 結果を画面に表示

**画面遷移**：
- 遷移元: WASM テストページインデックス（index.html）
- 関連画面: OPFS SAHPool Digest

**権限による表示制御**：特になし（開発者向けテストページ）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | SQLiteライブラリ初期化 | 主機能 | SAHPool VFS用モジュール初期化 |
| 43 | OS抽象化層（VFS） | 主機能 | OPFS SAHPool VFSのpause機能テスト |
| 42 | ミューテックス | 主機能 | 複数ページ・Worker間の協調アクセステスト |

## 画面種別

テスト実行・結果表示画面

## URL/ルーティング

```
/ext/wasm/tests/opfs/sahpool/index.html
```

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| cb-log-reverse | 入力 | checkbox | 任意 | ログ順序逆転 |
| テスト結果 | 出力 | text/HTML | - | 各操作のログと結果 |

## 表示項目

| 項目名 | 説明 | 表示条件 |
|--------|------|----------|
| タイトル（h1） | "sqlite3 tester: OpfsSAHPool Pausing" | 常時表示 |
| 説明文 | pause/unpause機能の基本的なデモである旨 | 常時表示 |
| ログ逆順チェックボックス | "Reverse log order?" | 常時表示 |
| テスト出力エリア | 各操作のログ | テスト実行中・完了後 |

## イベント仕様

### 1-ページ読み込み

1. sahpool-pausing.jsをロード
2. 2つのWorker（W1, W2）を起動
3. 両Workerの'initialized'メッセージを待機

### 2-両Worker初期化完了

initCount===2になったら:
1. runPyramidOfDoom(W1, W2)を呼び出し
2. コールバックチェーンでテストシーケンスを実行

### 3-Pyramid of Doom（テストシーケンス）

```
W1: vfs-acquire → db-init → db-query → vfs-pause
    ↓
W2: vfs-acquire → db-query → vfs-remove → endOfWork
```

### 4-Workerメッセージ受信

- `type: 'vfs-acquired'`: VFS取得完了
- `type: 'vfs-paused'`: VFS一時停止完了
- `type: 'vfs-unpaused'`: VFS再開完了
- `type: 'vfs-removed'`: VFS削除完了
- `type: 'db-inited'`: DB初期化完了
- `type: 'query-result'`: クエリ結果
- `type: 'log'`: ログ出力
- `type: 'error'`: エラー発生
- `type: 'initialized'`: Worker初期化完了

### 5-テスト完了

endOfWork()呼び出し時:
- 成功: h1に'tests-pass'クラス、タイトルに"PASS:"プレフィックス
- 失敗: h1に'tests-fail'クラス、タイトルに"FAIL:"プレフィックス

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| db-init | テスト用テーブル | CREATE/INSERT | DB初期化とサンプルデータ挿入 |
| db-query | テスト用テーブル | SELECT | データ照会 |

### テーブル別更新項目詳細

Worker内で作成されるテーブル。詳細はsahpool-worker.jsの実装に依存。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 情報 | "Running opfs-sahpool pausing tests..." | テスト開始時 |
| MSG002 | 情報 | "{workerId}: Worker initialized" | Worker初期化完了時 |
| MSG003 | 情報 | "VFS acquired" | VFS取得成功時 |
| MSG004 | 情報 | "VFS paused" | VFS一時停止成功時 |
| MSG005 | 情報 | "VFS unpaused" | VFS再開成功時 |
| MSG006 | 情報 | "VFS removed" | VFS削除成功時 |
| MSG007 | 情報 | "db initialized" | DB初期化成功時 |
| MSG008 | 情報 | "query result {payload}" | クエリ結果表示時 |
| MSG009 | 成功 | "End of work chain. If you made it this far, you win." | テスト成功時 |
| MSG010 | エラー | "{workerId}: {message}" | Worker内エラー発生時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| Worker内エラー | 'error'メッセージで通知、endOfWork(false)でFAIL表示 |
| VFS取得失敗 | エラーログ出力、テスト中断 |
| タイムアウト | 自動検出なし（手動確認必要） |

## 備考

- テストシーケンスはPromiseベースではなくコールバックチェーン（Pyramid of Doom）で実装
- W1がpause中にW2がVFSを取得できることがテストの核心
- Promise化の例は別ファイル（sqlite3-worker1-promiser.c-pp.js）を参照

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Worker間通信のメッセージ構造とコールバックキュー。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | sahpool-pausing.js | `ext/wasm/tests/opfs/sahpool/sahpool-pausing.js` | nextHandlerQueueとpostThen関数 |

**読解のコツ**: postThen(W, msgType, callback)でWorkerにメッセージ送信し、応答時にcallbackを実行。nextHandlerQueueにコールバックを積み、nextHandler()でシフト実行。

#### Step 2: エントリーポイントを理解する

HTMLファイルとメインスクリプトのロード。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html | `ext/wasm/tests/opfs/sahpool/index.html` | sahpool-pausing.jsのロード |

**主要処理フロー**:
1. **行29**: sahpool-pausing.jsをロード

#### Step 3: テスト制御を理解する

コールバックチェーンによるテストシーケンス。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | sahpool-pausing.js | `ext/wasm/tests/opfs/sahpool/sahpool-pausing.js` | runPyramidOfDoom関数 |

**主要処理フロー**:
- **行98-103**: nextHandlerQueueとnextHandler関数
- **行105-108**: postThen関数でメッセージ送信とコールバック登録
- **行119-133**: runPyramidOfDoom関数（コールバックチェーン）
- **行135-180**: runTests関数（Worker起動と初期化待機）

### プログラム呼び出し階層図

```
index.html
    │
    └─ <script src="sahpool-pausing.js">
           │
           ├─ runTests()
           │      │
           │      ├─ new Worker('sahpool-worker.js?workerId=w1')
           │      └─ new Worker('sahpool-worker.js?workerId=w2')
           │             │
           │             └─ onmessage: 'initialized' (x2)
           │                    │
           │                    └─ runPyramidOfDoom(W1, W2)
           │
           └─ runPyramidOfDoom(W1, W2)
                  │
                  ├─ postThen(W1, 'vfs-acquire')
                  │      └─ 'vfs-acquired' → nextHandler
                  │
                  ├─ postThen(W1, 'db-init')
                  │      └─ 'db-inited' → nextHandler
                  │
                  ├─ postThen(W1, 'db-query')
                  │      └─ 'query-result' → nextHandler
                  │
                  ├─ postThen(W1, 'vfs-pause')
                  │      └─ 'vfs-paused' → nextHandler
                  │
                  ├─ postThen(W2, 'vfs-acquire')
                  │      └─ 'vfs-acquired' → nextHandler
                  │
                  ├─ postThen(W2, 'db-query')
                  │      └─ 'query-result' → nextHandler
                  │
                  └─ postThen(W2, 'vfs-remove')
                         └─ 'vfs-removed' → endOfWork
```

### データフロー図

```
[Worker W1]                        [Worker W2]

vfs-acquire ──▶ VFS取得
     │
db-init ──▶ DB初期化
     │
db-query ──▶ クエリ実行
     │
vfs-pause ──▶ VFS一時停止
     │                              │
     └──────────────────────────────┤
                                    │
                              vfs-acquire ──▶ VFS取得（W1がpause中）
                                    │
                              db-query ──▶ クエリ実行
                                    │
                              vfs-remove ──▶ VFS削除
                                    │
                                    ▼
                              endOfWork() → PASS/FAIL表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `ext/wasm/tests/opfs/sahpool/index.html` | テンプレート | メイン画面HTML |
| sahpool-pausing.js | `ext/wasm/tests/opfs/sahpool/sahpool-pausing.js` | ソース | テスト制御（メインスレッド） |
| sahpool-worker.js | `ext/wasm/tests/opfs/sahpool/sahpool-worker.js` | ソース | 個別Workerの処理 |
| emscripten.css | `ext/wasm/common/emscripten.css` | スタイル | 共通スタイルシート |
| testing.css | `ext/wasm/common/testing.css` | スタイル | テストページ用スタイル |
